<?php

namespace App\Http\Controllers;

use App\Http\Requests\PaymentRequest;
use App\Models\Membership;
use App\Models\Transaction;
use Illuminate\Support\Facades\Auth;

class TransactionController extends Controller
{
    /**
     * Show the form for creating a new resource.
     */
    public function create($id)
    {
        $membership = Membership::with('membership_type', 'transactions')->find($id);
        $due = due_amount($membership->transactions);

        return view('payment.create', compact('membership', 'due'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(PaymentRequest $request)
    {
        $membership_id = $request->input('type');

        $membership = Membership::find($membership_id);
        $membership->transactions()->create([
            'amount' => (double) $request->input('amount'),
            'fee' => 0,
            'dr_cr' => 'cr',
            'date' => $request->input('date'),
            'method' => $request->input('method'),
            'note' => $request->input('note'),
            'created_user_id' => Auth::user()->id,
            'type' => 'membership fee'
        ]);

        return back()->with('success', 'Saved successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Transaction $transaction)
    {
        $transaction->delete();
        return back()->with('success', 'Deleted successfully');
    }
}